import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const minify = ({
                                              size = 24,
                                              fill = 'none',
                                              stroke = 'none',
                                              strokeWidth = 2,
                                              viewBox = '0 0 24 24',
                                              ...props
                                          }:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M9.9998 15.3998L4.0998 21.2998C3.91647 21.4831 3.68314 21.5748 3.3998 21.5748C3.11647 21.5748 2.88314 21.4831 2.6998 21.2998C2.51647 21.1165 2.4248 20.8831 2.4248 20.5998C2.4248 20.3165 2.51647 20.0831 2.6998 19.8998L8.5998 13.9998H4.9998C4.71647 13.9998 4.47897 13.904 4.2873 13.7123C4.09564 13.5206 3.9998 13.2831 3.9998 12.9998C3.9998 12.7165 4.09564 12.479 4.2873 12.2873C4.47897 12.0956 4.71647 11.9998 4.9998 11.9998H10.9998C11.2831 11.9998 11.5206 12.0956 11.7123 12.2873C11.904 12.479 11.9998 12.7165 11.9998 12.9998V18.9998C11.9998 19.2831 11.904 19.5206 11.7123 19.7123C11.5206 19.904 11.2831 19.9998 10.9998 19.9998C10.7165 19.9998 10.479 19.904 10.2873 19.7123C10.0956 19.5206 9.9998 19.2831 9.9998 18.9998V15.3998ZM15.3998 9.9998H18.9998C19.2831 9.9998 19.5206 10.0956 19.7123 10.2873C19.904 10.479 19.9998 10.7165 19.9998 10.9998C19.9998 11.2831 19.904 11.5206 19.7123 11.7123C19.5206 11.904 19.2831 11.9998 18.9998 11.9998H12.9998C12.7165 11.9998 12.479 11.904 12.2873 11.7123C12.0956 11.5206 11.9998 11.2831 11.9998 10.9998V4.9998C11.9998 4.71647 12.0956 4.47897 12.2873 4.2873C12.479 4.09564 12.7165 3.9998 12.9998 3.9998C13.2831 3.9998 13.5206 4.09564 13.7123 4.2873C13.904 4.47897 13.9998 4.71647 13.9998 4.9998V8.5998L19.8998 2.6998C20.0831 2.51647 20.3165 2.4248 20.5998 2.4248C20.8831 2.4248 21.1165 2.51647 21.2998 2.6998C21.4831 2.88314 21.5748 3.11647 21.5748 3.3998C21.5748 3.68314 21.4831 3.91647 21.2998 4.0998L15.3998 9.9998Z"
            fill={fill}
            stroke={stroke}
            strokeWidth={strokeWidth}
        />
    </svg>
);

export default minify;