<?php
/**
 * Copyright (C) 2014-2025 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Attribution: This code is part of the All-in-One WP Migration plugin, developed by
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wmke_FTP_Export_Connect {

	public static function execute( $params, $ftp = null ) {

		$model = new Ai1wmke_FTP_Settings();

		// Set progress
		Ai1wm_Status::info( sprintf( __( 'Connecting to %s server...', AI1WMKE_PLUGIN_NAME ), strtoupper( $model->get_type() ) ) );

		// Open the archive file for writing
		$archive = new Ai1wm_Compressor( ai1wm_archive_path( $params ) );

		// Append EOF block
		$archive->close( true );

		// Set FTP client
		if ( is_null( $ftp ) ) {
			$ftp = Ai1wmke_FTP_Factory::create(
				get_option( 'ai1wmke_ftp_type', AI1WMKE_FTP_TYPE ),
				get_option( 'ai1wmke_ftp_hostname', false ),
				get_option( 'ai1wmke_ftp_username', false ),
				get_option( 'ai1wmke_ftp_password', false ),
				get_option( 'ai1wmke_ftp_authentication', AI1WMKE_FTP_AUTHENTICATION ),
				get_option( 'ai1wmke_ftp_key', false ),
				get_option( 'ai1wmke_ftp_passphrase', false ),
				get_option( 'ai1wmke_ftp_directory', false ),
				get_option( 'ai1wmke_ftp_port', AI1WMKE_FTP_PORT ),
				get_option( 'ai1wmke_ftp_active', false )
			);
		}

		// Create folder
		$ftp->create_folder( ai1wm_archive_folder() );

		// Create incremental backups folder
		if ( ai1wmke_is_incremental( 'ftp' ) ) {
			$ftp->create_folder( sprintf( '%s/incremental-backups', ai1wm_archive_folder() ) );
		}

		// Set progress
		Ai1wm_Status::info( sprintf( __( 'Done connecting to %s server.', AI1WMKE_PLUGIN_NAME ), strtoupper( $model->get_type() ) ) );

		return $params;
	}
}
