<?php
/**
 * Copyright (C) 2014-2025 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Attribution: This code is part of the All-in-One WP Migration plugin, developed by
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wmke_Azure_Storage_Export_Retention extends Ai1wmke_Export_Retention_Base {

	/**
	 * Azure client
	 *
	 * @var Ai1wmke_Azure_Storage_Client
	 */
	protected $azure = null;

	/**
	 * Share name
	 *
	 * @var string
	 */
	protected $share_name = null;

	/**
	 * Folder name
	 *
	 * @var string
	 */
	protected $folder_name = null;

	protected function run() {
		// No bucket, no need to apply backup retention
		if ( ! $this->azure->is_share_available( $this->share_name ) ) {
			return $this->params;
		}

		return parent::run(); // TODO: Change the autogenerated stub
	}
	protected function setup_client( $client ) {
		// Set Azure Storage client
		if ( is_null( $client ) ) {
			$client = new Ai1wmke_Azure_Storage_Client(
				get_option( 'ai1wmke_azure_storage_account_name', false ),
				get_option( 'ai1wmke_azure_storage_account_key', false )
			);
		}

		$this->azure       = $client;
		$this->share_name  = $this->params['share_name'];
		$this->folder_name = $this->params['folder_name'];
	}

	protected function get_files() {
		$items = $this->azure->get_objects_by_share( $this->share_name, $this->folder_name );

		$backups = array();
		foreach ( $items as $item ) {
			if ( $item['type'] === 'file' && pathinfo( $item['name'], PATHINFO_EXTENSION ) === 'wpress' ) {
				$backups[] = $item;
			}
		}

		return Ai1wmke_File_Sorter::sort( $backups, Ai1wmke_File_Sorter::by_date_desc( $this->file_date_key() ) );
	}

	protected function delete_file( $backup ) {
		return $this->azure->remove_file( $backup['path'], $this->share_name );
	}

	protected function get_options_prefix() {
		return 'ai1wmke_azure_storage';
	}
}
